# -*- coding: UTF-8 -*-
import os
from java.io import File
from common.util import util, log
from common.constants import DISKLOGPATH, DISKLOGFILE
from common.constants import DISKPARAM_REMOTEPATH, DISKPARAM_REMOTEFILE
from common.constants import COMSCRIPTFILE, COMRESULTFILE
from download import DownByThread, WaitAndDownByThread, download_file_info
import com.huawei.ism.tool.infocollect.util.DataCollectConstants as dcc
import traceback


def collect(devObj):
    log.info(devObj, "start collect disk log")

    try:
        devObj["collectRemoteFileName"] = DISKLOGFILE
        devObj["collecRemotePath"] = DISKLOGPATH
        isSuccess, errMsg = doCollect(devObj)
    except Exception as err:
        devObj["py_detail"] = 'collect disk log script execute Error.'
        log.error(devObj, "catch except when collect DiskLog,info:%s"
                  % str(err).encode("utf-8"))
        log.error(devObj, "catch except when collect DiskLog,info:%s"
                  % str(traceback.format_exc()).encode("utf-8"))
        return (False, "")
    finally:
        try:
            ssh = devObj.get("SSH")
            ssh.execCmd("rm -f %s" % DISKLOGPATH)
            ssh.execCmd("rm -f %s/%s"
                        % (DISKPARAM_REMOTEPATH, DISKPARAM_REMOTEFILE))
        except Exception as err:
            log.error(devObj,
                      "catch except when collect DiskLog,del file(%s) ERR:%s"
                      % (devObj.get("collecRemotePath"),
                         str(err).encode("utf-8")))
            log.error(devObj, "catch except when delete DiskLog,info:%s"
                      % str(traceback.format_exc()).encode("utf-8"))
        else:
            log.info(devObj, "delete file(%s) success for module DiskLog"
                     % devObj.get("collecRemotePath"))
    return isSuccess, errMsg


def doCollect(devObj):
    '''
    @devObj: Java传递给Python脚本的上下文。
    @summary:执行磁盘日志收集
    @return: boolean, string  (收集成功, _)
    '''
    colltype = "DiskLog"
    action = "collect"
    diskparam = ""
    sftp = devObj.get("SFTP")
    tempPath = os.path.dirname(__file__)
    filePath = str(tempPath) + "\\" + str(DISKPARAM_REMOTEFILE)
    selDiskList = devObj.get(dcc.SELECTTED_DISK_FOR_OS9000_KEY_IN_PYENV)

    diskmap = {}
    fileHandle = open(filePath, 'w')
    for diskObj in selDiskList:
        nodid = diskObj.getNodeId()
        nodeSn = diskObj.getDiskSn()
        if nodid not in diskmap:
            diskmap[nodid] = []
        diskmap[nodid].append(nodeSn)

    # 拼接参数diskparam
    for key in diskmap:
        diskparam = key + '='
        tmpdiskNum = 0
        alldiskNum = len(diskmap[key])
        for item in diskmap[key]:
            tmpdiskNum += 1
            if alldiskNum == tmpdiskNum:
                diskparam = diskparam + item + ' '
            else:
                diskparam = diskparam + item + ':'

        fileHandle.write(str(diskparam) + "\n")
        log.info(devObj, "param info:%s." % diskparam)

    fileHandle.close()
    if os.path.exists(filePath):
        sftp.putFile(File(filePath), DISKPARAM_REMOTEPATH, None)
    else:
        log.error(devObj, "param file error")
        util.setPyDetailMsg(devObj, 'coll.param.error')
        return (False, "")

    # 防止设备踢session
    util.execCmdWithTimout(devObj, "TMOUT=0", 20)
    # 新老接口区分
    devNode = devObj.get("devNode")
    version = devNode.getProductVersion()
    isOldVersion = True
    isOldVersion = util.IsOldVersion(version)

    # 收集磁盘日志
    collRate = 80
    tmpFile = str(DISKPARAM_REMOTEPATH + "/" + DISKPARAM_REMOTEFILE)
    if isOldVersion:
        scriptFile = "/opt/huawei/snas/bin/datacollect_ModuleEntry.sh"
        cmd = 'sudo %s "%s" "%s" "%s" > %s &' \
              % (scriptFile, colltype, action, tmpFile, COMRESULTFILE)
    else:
        cmd = 'sudo  %s "%s" "%s" "%s" &' \
              % (COMSCRIPTFILE, colltype, action, tmpFile)
    strRet = util.ExecCollectAsyn(devObj, cmd)
    collRate = WaitAndDownByThread(devObj)
    strRet = util.GetCollectResult(devObj)

    # 删除文件
    if os.path.exists(filePath):
        os.remove(filePath)

    # 检查收集结果
    isSuccess, retInfo = util.GetMessageInfo(devObj, strRet)
    if not isSuccess:
        log.error(devObj, "collect disk log failed, ret=%s" % strRet)
        return (False, "")

    # 执行下载任务
    file_info = download_file_info()
    file_info.remoteFileName = devObj.get("collecRemotePath")
    file_info.localFileName = os.path.join(devObj.get("collectRetDir"),
                                           devObj.get("collectRemoteFileName"))
    isSuccess, retInfo = DownByThread(devObj, collRate, 100, file_info)
    if not isSuccess:
        log.error(devObj, "download DiskLog failed, ret=%s" % retInfo)

    return (isSuccess, retInfo)
